#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;

struct Jarbol {
    long long x;
    long long h;
    int index;
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<long long> x(n), h(n);
    for(int i = 0; i < n; i++){
        cin >> x[i];
    }
    for(int i = 0; i < n; i++){
        cin >> h[i];
    }

    vector<Jarbol> a(n);
    for(int i = 0; i < n; i++){
        a[i] = {x[i], h[i], i};
    }

    sort(a.begin(), a.end(), [](const Jarbol& A, const Jarbol& B){
        return A.x < B.x;
    });

    vector<int> najblizi_visi_levo(n), najblizi_visi_desno(n);
    vector<int> st;
    st.reserve(n);

    st.clear();
    for(int i = 0; i < n; i++){
        long long hi = a[i].h;
        while(!st.empty() and a[st.back()].h < hi){
            st.pop_back();
        }
        if(st.empty()){
            najblizi_visi_levo[i] = -1;
        } 
        else{
            najblizi_visi_levo[i] = st.back();
        }
        st.push_back(i);
    }

    st.clear();
    for(int i = n - 1; i >= 0; i--){
        long long hi = a[i].h;
        while(!st.empty() and a[st.back()].h < hi){
            st.pop_back();
        }
        if(st.empty()){
            najblizi_visi_desno[i] = -1;
        } 
        else{
            najblizi_visi_desno[i] = st.back();
        }
        st.push_back(i);
    }

    const long long INF = (1LL << 60);
    vector<long long> udaljenosti(n, -1);

    for(int i = 0; i < n; i++){
        long long xi = a[i].x;
        long long hi = a[i].h;
        long long najmanja_udaljenost = INF;

        int j = najblizi_visi_levo[i];
        if(j != -1){
            long long xj = a[j].x;
            long long hj = a[j].h;
            long long dx = xi - xj;
            long long dh = hj - hi;
            long long r = dx - dh;
            if (r < 0) r = 0;
            if (r < najmanja_udaljenost) {
                najmanja_udaljenost = r;
            }
        }

        j = najblizi_visi_desno[i];
        if(j != -1){
            long long xj = a[j].x;
            long long hj = a[j].h;
            long long dx = xj - xi;
            long long dh = hj - hi;
            long long r = dx - dh;
            if(r < 0){
                r = 0;
            }
            if(r < najmanja_udaljenost){
                najmanja_udaljenost = r;
            }
        }

        if(najmanja_udaljenost == INF){
            udaljenosti[a[i].index] = -1;
        } 
        else{
            udaljenosti[a[i].index] = najmanja_udaljenost;
        }
    }

    for(int i = 0; i < n; i++){
        cout << udaljenosti[i] << '\n';
    }

    return 0;
}